/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.utility.colors;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.theme.Theme;
import Krasnodar.rockstarnew.utility.animation.types.ColorAnimation;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import lombok.Generated;

public final class Colors {
    public static final ColorRGBA RED = new ColorRGBA(255.0f, 0.0f, 0.0f);
    public static final ColorRGBA GREEN = new ColorRGBA(0.0f, 255.0f, 0.0f);
    public static final ColorRGBA BLUE = new ColorRGBA(0.0f, 0.0f, 255.0f);
    public static final ColorRGBA WHITE = new ColorRGBA(255.0f, 255.0f, 255.0f);
    public static final ColorRGBA BLACK = new ColorRGBA(0.0f, 0.0f, 0.0f);
    public static final ColorRGBA ACCENT = new ColorRGBA(151.0f, 71.0f, 255.0f);
    private static final long ANIMATION_DURATION = 500L;
    private static final ColorAnimation BACKGROUND_COLOR_ANIMATION = new ColorAnimation(500L);
    private static final ColorAnimation ADDITIONAL_COLOR_ANIMATION = new ColorAnimation(500L);
    private static final ColorAnimation TEXT_COLOR_ANIMATION = new ColorAnimation(500L);
    private static final ColorAnimation OUTLINE_COLOR_ANIMATION = new ColorAnimation(500L);
    private static final ColorAnimation FLAT_COLOR_ANIMATION = new ColorAnimation(500L);

    private static Theme getTheme() {
        return Rockstar.getInstance().getThemeManager().getCurrentTheme();
    }

    public static ColorRGBA getBackgroundColor() {
        return Colors.getAnimatedColor(BACKGROUND_COLOR_ANIMATION, Colors.getTheme().getBackgroundColor());
    }

    public static ColorRGBA getAdditionalColor() {
        return Colors.getAnimatedColor(ADDITIONAL_COLOR_ANIMATION, Colors.getTheme().getAdditionalColor());
    }

    public static ColorRGBA getTextColor() {
        return Colors.getAnimatedColor(TEXT_COLOR_ANIMATION, Colors.getTheme().getTextColor());
    }

    public static ColorRGBA getOutlineColor() {
        return Colors.getAnimatedColor(OUTLINE_COLOR_ANIMATION, Colors.getTheme().getOutlineColor());
    }

    public static ColorRGBA getFlatColor() {
        return Colors.getAnimatedColor(FLAT_COLOR_ANIMATION, Colors.getTheme().getFlatColor());
    }

    public static ColorRGBA getSeparatorColor() {
        return ColorRGBA.BLACK.withAlpha(255.0f * (Colors.getTheme() == Theme.DARK ? 0.08f : 0.05f));
    }

    private static ColorRGBA getAnimatedColor(ColorAnimation animation, ColorRGBA color) {
        animation.update(color);
        return animation.getColor();
    }

    @Generated
    private Colors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

